#include <iostream>
#include <vector>
#include <unordered_map>
#include <climits>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (auto& x : a) cin >> x;

    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, vector<int>> sum_positions;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i)
        sum_positions[prefix[i]].push_back(i);

    int answer = 0;

    for (auto& [s, indices] : sum_positions) {
        int sz = indices.size();
        for (int i = 0; i < sz; ++i) {
            for (int j = i + 1; j < sz; ++j) {
                int l = indices[i];
                int r = indices[j];

                unordered_map<long long, int> freq;
                int maxFreq = 0;
                for (int k = l; k < r; ++k) {
                    freq[a[k]]++;
                    maxFreq = max(maxFreq, freq[a[k]]);
                }

                answer = max(answer, maxFreq);
            }
        }
    }

    cout << answer << '\n';//tralala
    return 0;
}